#!/usr/bin/python3

# This demo will show how to start data streaming in Dewetron Oxygen and
# receive the data using the dt_client example program
# It requires a local oxygen with the SCPI plugin listening on TCP 10001

import telnetlib
import time

def sendCommands(telnet, seq):
    for cmd in seq:
        send_cmd = (cmd + "\n").encode("ascii")
        print(cmd)
        telnet.write(send_cmd)
        time.sleep(0.25) # Wait until command is processed

HOST  = "localhost"
CMD_PORT  = 10001
CHANNELS = ["AI 1/3 Sim", "AI 1/4 Sim"]

telnet = telnetlib.Telnet()
telnet.open(HOST, CMD_PORT)

# Reset
sendCommands(telnet, [":DST:RES"])

items_cmd = ":DST:ITEMS \"" + ('", "'.join(CHANNELS)) + "\""

# write parameters
print("Writing DataStream parameters...")
cmd_sequence = [
    items_cmd,
    ":DST:PORT 5555",
    ":DST:INIT ALL",
]
sendCommands(telnet, cmd_sequence)

print("You can now start the dt_client program. Use the --verbose option to see incoming packages.")
print("")

print("Available commands:")
print("  start: start streaming (after the client is connected)")
print("  stop:  stop streaming")
print("  quit:  quit")

run = True
received_data = []
while run:
    print("Input: ")
    command = input()

    if command == "quit":
        run = False
    elif command == "start":
        sendCommands(telnet, [":DST:STAR ALL"])
    elif command == "stop":
        sendCommands(telnet, [":DST:STOP ALL"])
  
sendCommands(telnet, [":DST:DEL ALL"])
